/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: TestRunner.scala 817 2008-01-25 19:44:05Z ms $
 */
package ch.ethz.inf.sct.uts.test.helpers;

import scala.testing.SUnit
import SUnit._

/**
 * Class which implements a main method that executes the actual 
 * tests and prints some statistics at the end. If any tests failed,
 * it exits with a non-zero exit status.
 * 
 * @author  Manfred Stock
 * @version $Revision: 817 $
 */
trait TestRunner extends TestUtils {
  /**
   * Create a testsuite with the tests that should be executed.
   * @return the created testsuite.
   */
  def suite : TestSuite
    
  /**
   * Testdata - a list with classname, expected error/warning count, a name for the test case, 
   * and if an exception is expected..
   */
  val testdata : List[Any]
  
  /**
   * Arguments passed to the <code>main</code> function.
   */
  var testArgs : List[String] = Nil
  
  /**
   * Main method which executes the tests.
   * @param args Arguments to the main method.
   */
  def main(args: Array[String]) {
    testArgs = args.toList
    val r = new TestResult()
    suite.run(r)
    for (tf <- r.failures()) 
      println(tf.toString())
          
    val result = "Executed a total number of "+testdata.length+" tests of which "+r.failureCount+" tests failed."
    val bar = line('-',result)
    (if (r.failureCount > 0) { System.err } else { System.out }).println("\n"+bar+"\n"+result+"\n"+bar+"\n")

    if (r.failureCount > 0) {
      exit(1)
    }
  }
}
