/*
 * This file is part the Universe Runtime Classes.
 *
 * Copyright (C) 2003-2005 Swiss Federal Institute of Technology Zurich
 *
 * Part of mjc, the MultiJava Compiler.
 *
 * Copyright (C) 2000-2005 Iowa State University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: UrtStrict.java,v 1.1 2005/06/12 19:38:28 wdietl Exp $
 */

package org.multijava.universes.rt.policy;

import org.multijava.universes.rt.UniverseRuntime;
import org.multijava.universes.rt.UrtPolicy;

/**
 * Alternative implementation of UrtDefaultPolicy that does treat objects
 * that have been created in non-universe aware code as readonly and
 * throws an error when somebody asks for an already collected owner.
 * 
 * @author scdaniel
 */
public class UrtStrict
    extends UrtDefaultPolicy
    implements UrtPolicy {

    private Object externalOwner;
	
    /**
     * Constructor.
     * Establishes externalOwner as the owner of a designated special Universe
     * for Universe aware Objects created outside of universe aware code.
     */
    public UrtStrict () {
	externalOwner = new Object();
	UniverseRuntime.handler.setOwnerRep(externalOwner,
					    Thread.currentThread());
    }
	
    /**
     * External objects are not peer, but readonly.
     * 
     * @return	false
     */
    public boolean isExternalPeer () {
	return false;
    }
	
    /**
     * Universe objects generated from external code belong
     * to a separate Universe.
     * 
     * @return	the owner of the separate "external" Universe
     */
    public Object getNativeOwner (Object obj) {
	return externalOwner;
    }
	
    /**
     * If somebody asks for an already collected owner,
     * throw a RuntimeException.
     */
    public Object getCollectedOwner () {
	throw new RuntimeException();
    }
}
