package ch.ethz.inf.sct.uts.examples.static

import ch.ethz.inf.sct.uts.annotation._

class StaticObject {
  abstract class A {
    val a : C @rep
    
    def foo = {
      new (C @rep) 
    }
    
    def bar = {
      new C
    }
  }
  
  class C
  
  // Defaults to @peer
	object O extends A {
    // Ok
    val a = foo
    
    var b = bar
    // Not ok
    b = new (C @rep)
    
    // Ok
    var c = foo
    c = new (C @rep)
    
    val d = new C
  }
  
  // Ok
  val a = O.a
  val b = O.b
  val c = O.c
  
  // Not ok
  val d : C @peer = O.a
  
  // Not ok
  val e : C @rep = O.d
  // Ok
  val f = O.d
  val g : C @peer = O.d
  
  def x : A @any = O
  
  val h = StaticObject.f
  // Not ok
  val i : Int @rep = StaticObject.f
  // Not ok
  val j : Int @peer = StaticObject.f
  
  // Ok
  val k : Int @any = StaticObject.f
}

object StaticObject {
  val f = 0
}