package ch.ethz.inf.sct.uts.examples.static

import ch.ethz.inf.sct.uts.annotation._

class MethodCalls {
  val m = new Methods
  // Ok
  m.f1[Float](10)
  
  // Ok
  m.f1[Int](10)
  
  // Ok
  m.f3(10.0)
  
  val m2 : Methods @any = new Methods
  // Ok
  m2.f3(10)
  
  // Not ok (lost)
  m2.f4(10)
  
  // Not ok (f5 nonpure)
  m2.f5
  
  // Ok
  m2.f6
}

class Methods {
  var x : Int = 0
  
  @pure def f1[X] (v: X) : X = {
    v
  }
  
  @pure def f2[T, U <: T] (v: U) : T = {
    v
  }
  
  @pure def f3(v: Double) {
    v*2.0
  }
  
  def f4(v: Int) {
    x = v
  }
  
  def f5 {
    x = 0
  }
  
  @pure def f6 {}
}