package stack
import ch.ethz.inf.sct.uts.annotation._

class Stack[T] {
  private var stop: Element[T] @rep = null
  def push(value: T) {
    stop = new (Element[T] @rep)(value, stop) 
  }
  def pop = {
    val res = top
    if (stop != null) { stop = stop.next }
    res
  }
  @pure def top = 
    if (stop != null) { stop.value }
    else { null.asInstanceOf[T] }
  @pure def empty = stop == null
}
