package ch.ethz.inf.sct.uts.plugin
import scala.tools.nsc._
import scala.tools.nsc.plugins._

/** Compiler plugin for the Scala compiler. */
class TestPlugin(val global: Global) extends Plugin {
  /** Name of this plugin. */
  val name = "plugin"
    
  /** Description of this plugin. */
  val description = "Compiler plugin."

  /** Components of this plugin. */
  val components = List(
  	new PluginComponent0(global),
	new PluginComponent1(global)
  )
  
  /** A description of this plugin's options, for -help. */
  override val optionsHelp: Option[String] = Some(description)
}

/** Plugin component which runs after runsAfter. */
class PluginComponent0 (val global: Global) 
  extends PluginComponent {
  import global._
  /** Name of this compiler phase. */
  val phaseName = "phase0"
      
  /** When to execute this phase. */
  val runsAfter = "refchecks"
      
  /** Factory to create the new phase for the graph generation. */
  def newPhase(prev: Phase) = new Phase(prev) {
    def name = phaseName
      
    /** Process the compilation units. */
    def run {
      println(phaseName+" done.")
    }
  }
}

/** Another plugin component which runs after runsAfter. */
class PluginComponent1 (val global: Global) 
  extends PluginComponent {
  import global._
  /** Name of this compiler phase. */
  val phaseName = "phase1"
      
  /** When to execute this phase. */
  val runsAfter = "refchecks"
      
  /** Factory to create the new phase for the graph generation. */
  def newPhase(prev: Phase) = new Phase(prev) {
    def name = phaseName
      
    /** Process the compilation units. */
    def run {
      println(phaseName+" done.")
    }
  }
}
