package complex
/** Static object for complex numbers */
object Complex {
  val i = Complex(0,1)
  implicit def double2complex(x: Double) = Complex(x,0)
  implicit def int2complex(x: Int) = Complex(x.toDouble,0)
  def apply(re: Double, im: Double) = new Complex(re,im)
}
/** Class representing complex numbers */
class Complex(val re: Double, val im: Double) {
  def +(that: Complex) = Complex(this.re + that.re, this.im + that.im)
  def -(that: Complex) = Complex(this.re - that.re, this.im - that.im)
  def *(that: Complex) = Complex(this.re * that.re - this.im * that.im, 
                                 this.re * that.im + this.im * that.re) 
  def /(that: Complex) = {  
    val denom = that.re * that.re + that.im * that.im 
    Complex(
        (this.re * that.re + this.im * that.im) / denom, 
        (this.im * that.re - this.re * that.im) / denom
    ) 
  }
  override def toString = re+(if (im < 0) "-" + (-im) else"+" + im) + "*I"
}