/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: UniverseRuntimeHashtableTest.scala 817 2008-01-25 19:44:05Z ms $
 */
package ch.ethz.inf.sct.uts.test;

import scala.testing.SUnit
import SUnit._
import ch.ethz.inf.sct.uts.rt._
import ch.ethz.inf.sct.uts.rt.implementation._
import ch.ethz.inf.sct.uts.test.helpers._
import java.lang.ref.ReferenceQueue

/**
 * Simple test for the hashtable.
 * 
 * @author  Manfred Stock
 * @version $Revision: 817 $
 */
object UniverseRuntimeHashtableTest extends TestUtils with TestRunner {
  val table = new Hashtable
  
  val testdata = List(
      // Insert and remove one entry
      new TestCase("BasicTest") {
        def runTest {
          val a = new Obj(0)
          val entry = table.put(a,new HashtableEntry(new UrtWeakReference(this)))
          println(table)
          assertTrue("Get failed",table.get(a) match {
            case Some(entry) => entry.obj.get == a
            case None        => false
          })
          table.remove(entry)
          assertTrue("Remove failed",table.get(a) match {
            case Some(obj) => false
            case None      => true
          })
          println(table)
          println(name+" done.")
        }
      },
      // Insert and remove some more entries
      new TestCase("LargerTest") {
        def runTest {
          val a = (for (i <- 0 until 500000) yield new Obj(i)).toList
          val entries = a map { e =>
            val owner = table.get(this) match {
              case Some(entry) => entry
              case None        => table.put(this,new HashtableEntry(new UrtWeakReference(table)))
            }
            //println("Inserting "+e+"...")
            table.put(e,owner)
          }
          //println("Table after insertion:\n"+table)
          a foreach {e => assertTrue("Get failed",table.get(e) match {
            case Some(entry) => entry.obj.get == e
            case None        => false
          })}
          entries foreach table.remove
          entries foreach {e => assertTrue("Remove failed",table.get(e) match {
            case Some(obj) => false
            case None      => true
          })}
          //println("Table after deletion:\n"+table)
          println(name+" done.")
        }
      }  
  )
  
  /**
   * Create a testsuite suitable for execution.
   * @return the generated testsuite.
   */
	def suite : TestSuite = {
    val suite = new TestSuite
    testdata foreach suite.addTest
    suite
  }
  
  /**
   * Dummy object for insertion into hashtable.
   * @param i Some integer value which will be contained in the output 
   *          of the <code>toString</code> method.
   */
  class Obj(val i: Int) {
    /**
     * Convert object to a string.
     * @return the string representation of this object.
     */
    override def toString: String = {
      "An Object: "+i
    }
  }
}
