/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: StaticErrors.scala 817 2008-01-25 19:44:05Z ms $
 */
package ch.ethz.inf.sct.uts.plugin.staticcheck.common

import scala.tools.nsc._

/**
 * Trait which provides some methods which can be used to consistently convert 
 * different kinds of errors to readable strings. 
 * 
 * @author  Manfred Stock
 * @version $Revision: 817 $
 */
trait StaticErrors[G <: Global] {
  self: TypeAbstraction[G] => 

  /**
   * Create string to describe a type error.
   * @param found    The type which was actually found.
   * @param expected The type which was expected.
   * @param comment  An additional comment.
   */
  def typeError(found: UType, expected: UType, comment: String) : String = {
    "\nType error: "+
      "\n found:    "+found+
      "\n expected: "+expected+
      (if (comment != null && comment != "") "\n"+comment else "")
  }

  /**
   * Create string to describe mismatched method signature errors.
   * @param found    The signature which was actually found.
   * @param expected The signature which was expected.
   * @param comment  An additional comment.
   */
  def mismatchedMethods(found: MethodSignature, expected: MethodSignature, comment: String) : String = {
    "\nMismatched method signatures: "+
      "\n found:    "+found+
      "\n expected: "+expected+
      (if (comment != null && comment != "") "\n"+comment else "")
  }
}