/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: RuntimePlugin.scala 883 2008-02-01 18:59:56Z ms $
 */
package ch.ethz.inf.sct.uts.plugin.runtimecheck

import scala.tools.nsc.Global
import scala.tools.nsc.plugins.Plugin
import ch.ethz.inf.sct.uts.plugin.common._

/**
 * Compiler-plugin for the Scala compiler to do a runtime check of Universe type system rules.
 * 
 * @author  Manfred Stock
 * @version $Revision: 883 $
 */
class RuntimePlugin(global: Global) extends UniverseTypeSystemPlugin(global) {
  /**
   * Name of this plugin.
   */
  val name = "uts-runtime"
  
  /**
   * Description of this plugin.
   */
  val description = "Dynamically check Universe type system rules at runtime."

  /**
   * The universe type system checker component.
   */
  val utscc = new RuntimeComponent(global)
  
  /**
   * Components of this plugin. Currently only the Universe type system checker.
   */
  val components = List(utscc)
  
  /**
   * Handle any plugin-specific options.
   * @param options List of the given options for this plugin.
   * @param error Function used to display a potential error.
   */
  override def processOptions(options: List[String], error: String => Unit) {
    processCommonOptions(options) foreach {
      case "runtime=mj" => utscc.setMJRuntime
      case "runtime=sc" => utscc.setSCRuntime
      case o => error("Unknown option "+o+" for "+name) 
    }
  }
  
  /** 
   * A description of this plugin's options, suitable as a response
   * to the -help command-line option.
   */
  override val optionsHelp: Option[String] = Some(
      (super.optionsHelp match {
         case Some(str) => str
         case None      => ""
      })+"-P:"+name+":runtime=mj Use the MultiJava runtime check support classes as target of the generated runtime checks.\n"+
         "-P:"+name+":runtime=sc Use the Scala implementation of the runtime check support classes as target of the generated runtime checks.\n"
  )
}