package ch.ethz.inf.sct.uts.examples.static

import ch.ethz.inf.sct.uts.annotation._

class AClass {
  def f : Int = {
    1
  }
  
  def newA : AClass @rep = {
    new AClass @rep
  }
  
  def overload(a: AClass @rep) : AClass @rep = {
    a
  }
  
  def overload(b: BClass @peer) : BClass @peer = {
    b
  }
  
  def purity0 = {}
  
  @pure def purity1 = {}
  
  @pure def purity2 = {}
}

class BClass extends AClass {
  // Ok
  override def f : Int = {
    2
  }
  
  // Not ok (@peer instead of @rep)
  override def newA : AClass @peer = {
    new AClass @peer
  }
  
  // Not ok (@rep annotations instead of @peer)
  override def overload(a: BClass @rep) : BClass @rep = {
    a
  }
  
  //Not ok (@peer in return value instead of @rep)
  override def overload(a: AClass @rep) : AClass @peer = {
    new AClass
  }
  
  // Ok, overriding method may be pure
  @pure override def purity0 = {}
  
  // Not ok, overriding method must not be non-pure if the overriden method was
  override def purity1 = {}
  
  // Ok, no change in purity
  @pure override def purity2 = {}
}

class CClass[T] {
  var cv: T = _
  
  def f : T = {
    cv
  }
}

class DClass extends CClass[Int] {}

object test {
  var dc = new DClass
  dc.cv = 1
  var cc = new CClass[Int]
  cc.cv = 1
}