/*
 * Decompiled with CFR 0.152.
 */
package org.multijava.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public abstract class Utils
implements Cloneable {
    public static final int DBG_LEVEL_NO = 0;
    public static final int DBG_LEVEL_LOW = 1;
    public static final int DBG_LEVEL_HIGH = 2;
    private static String CURRENT = ".";
    private static String UP = "..";
    private static String FILE_SEP = System.getProperty("file.separator");
    private static boolean caseInsensitiveFS = FILE_SEP.equals("\\") || System.getProperty("os.name").indexOf("Mac") >= 0;
    private static final boolean DEBUG_ENABLED = true;
    private static int debugLevel = 2;

    public static final void assertTrue(boolean b, String message) {
        if (!b) {
            RuntimeException re = new RuntimeException(message);
            re.printStackTrace();
            if (debugLevel > 0) {
                throw re;
            }
        }
    }

    public static final void fail(String message) {
        RuntimeException re = new RuntimeException(message);
        re.printStackTrace();
        if (debugLevel > 0) {
            throw re;
        }
    }

    public static final void assertTrue(boolean b) {
        if (!b) {
            RuntimeException re = new RuntimeException("assertion failed");
            re.printStackTrace();
            if (debugLevel > 0) {
                throw re;
            }
        }
    }

    public static final void fail() {
        RuntimeException re = new RuntimeException("fail reached");
        re.printStackTrace();
        if (debugLevel > 0) {
            throw re;
        }
    }

    public static boolean hasFlag(long modifiers, long flags) {
        return (modifiers & flags) != 0L;
    }

    public static boolean hasOtherFlags(long modifiers, long flags) {
        return (modifiers & flags) != modifiers;
    }

    public static long stripNonJavaModifiers(long modifiers) {
        return modifiers & 0xFFFFL;
    }

    public static long stripJavaModifiers(long modifiers) {
        return modifiers & 0xFFFFFFFFFFFF0000L;
    }

    public static long stripPrivateModifier(long modifiers) {
        return modifiers & 0xFFFFFFFFFFFFFFFDL;
    }

    public static Object[] vectorToArray(Vector vect, Class type) {
        if (vect != null && vect.size() > 0) {
            Object[] array = (Object[])Array.newInstance(type, vect.size());
            try {
                vect.copyInto(array);
            }
            catch (ArrayStoreException e) {
                System.err.println("Array was:" + vect.elementAt(0));
                System.err.println("New type :" + array.getClass());
                throw e;
            }
            return array;
        }
        return (Object[])Array.newInstance(type, 0);
    }

    public static int[] vectorToIntArray(Vector vect) {
        if (vect != null && vect.size() > 0) {
            int[] array = new int[vect.size()];
            for (int i = array.length - 1; i >= 0; --i) {
                array[i] = (Integer)vect.elementAt(i);
            }
            return array;
        }
        return new int[0];
    }

    public static Object[] combineArrays(Object[] x, Object[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        Object[] res = (Object[])Array.newInstance(x.getClass().getComponentType(), x.length + y.length);
        System.arraycopy(x, 0, res, 0, x.length);
        System.arraycopy(y, 0, res, x.length, y.length);
        return res;
    }

    public static String[] splitQualifiedName(String name, char separator) {
        String[] result = new String[2];
        int pos = name.lastIndexOf(separator);
        if (pos == -1) {
            result[0] = "";
            result[1] = name;
        } else {
            result[0] = name.substring(0, pos);
            result[1] = name.substring(pos + 1);
        }
        return result;
    }

    public static String[] splitQualifiedName(String name) {
        return Utils.splitQualifiedName(name, '/');
    }

    public static final String unescapeString(String val) {
        char[] buffer = new char[val.length()];
        char[] old = val.toCharArray();
        if (old.length > buffer.length) {
            buffer = new char[old.length];
        }
        int pos = 0;
        int outPos = 0;
        while (pos < old.length) {
            int out;
            if (old[pos] != '\\') {
                out = old[pos];
                ++pos;
            } else {
                boolean zeroToThree = false;
                switch (old[pos + 1]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        zeroToThree = true;
                    }
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        String octal;
                        if (pos + 2 < old.length && old[pos + 2] >= '0' && old[pos + 2] <= '7') {
                            if (zeroToThree && pos + 3 < old.length && old[pos + 3] >= '0' && old[pos + 3] <= '7') {
                                octal = new String(old, pos + 1, 3);
                                pos += 4;
                            } else {
                                octal = new String(old, pos + 1, 2);
                                pos += 3;
                            }
                        } else {
                            octal = new String(old, pos + 1, 1);
                            pos += 2;
                        }
                        out = (char)Integer.parseInt(octal, 8);
                        break;
                    }
                    case 'u': {
                        String unicode = new String(old, pos + 2, 4);
                        out = (char)Integer.parseInt(unicode, 16);
                        pos += 6;
                        break;
                    }
                    case 'n': {
                        out = 10;
                        pos += 2;
                        break;
                    }
                    case 'r': {
                        out = 13;
                        pos += 2;
                        break;
                    }
                    case 't': {
                        out = 9;
                        pos += 2;
                        break;
                    }
                    case 'b': {
                        out = 8;
                        pos += 2;
                        break;
                    }
                    case 'f': {
                        out = 12;
                        pos += 2;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        out = old[pos + 1];
                        pos += 2;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("bad escape sequence in " + val);
                    }
                }
            }
            buffer[outPos++] = out;
        }
        return new String(buffer, 0, outPos);
    }

    public static final String escapeString(String val) {
        return Utils.escapeString(val, true);
    }

    public static final String escapeString(String val, boolean escapeApostrophes) {
        char[] buffer = new char[val.length() * 2];
        char[] old = val.toCharArray();
        int pos = 0;
        block10: for (int i = 0; i < old.length; ++i) {
            switch (old[i]) {
                case '\b': {
                    buffer[pos++] = 92;
                    buffer[pos++] = 98;
                    continue block10;
                }
                case '\t': {
                    buffer[pos++] = 92;
                    buffer[pos++] = 116;
                    continue block10;
                }
                case '\n': {
                    buffer[pos++] = 92;
                    buffer[pos++] = 110;
                    continue block10;
                }
                case '\f': {
                    buffer[pos++] = 92;
                    buffer[pos++] = 102;
                    continue block10;
                }
                case '\r': {
                    buffer[pos++] = 92;
                    buffer[pos++] = 114;
                    continue block10;
                }
                case '\"': {
                    buffer[pos++] = 92;
                    buffer[pos++] = 34;
                    continue block10;
                }
                case '\'': {
                    if (escapeApostrophes) {
                        buffer[pos++] = 92;
                        buffer[pos++] = 39;
                        continue block10;
                    }
                    buffer[pos++] = old[i];
                    continue block10;
                }
                case '\\': {
                    buffer[pos++] = 92;
                    buffer[pos++] = 92;
                    continue block10;
                }
                default: {
                    buffer[pos++] = old[i];
                }
            }
        }
        return new String(buffer, 0, pos);
    }

    public static final String relativePathTo(File file) {
        File user = new File(System.getProperty("user.dir")).getAbsoluteFile();
        File reference = file.isAbsolute() ? file : file.getAbsoluteFile();
        try {
            user = user.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            reference = reference.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        List userParts = Utils.parsePathParts(user);
        List referenceParts = Utils.parsePathParts(reference);
        while (userParts.size() > 0 && referenceParts.size() > 0 && (!caseInsensitiveFS || ((String)userParts.get(0)).equalsIgnoreCase((String)referenceParts.get(0))) && (caseInsensitiveFS || userParts.get(0).equals(referenceParts.get(0)))) {
            userParts.remove(0);
            referenceParts.remove(0);
        }
        StringBuffer result = new StringBuffer();
        while (userParts.size() > 0) {
            result.append(FILE_SEP).append(UP);
            userParts.remove(0);
        }
        while (referenceParts.size() > 0) {
            Object first = referenceParts.remove(0);
            result.append(FILE_SEP).append(first);
        }
        result.delete(0, FILE_SEP.length());
        if (result.length() == 0) {
            return CURRENT;
        }
        return result.toString();
    }

    public static final List parsePathParts(File path) {
        LinkedList<String> result = new LinkedList<String>();
        while (path != null) {
            if (!path.getName().equals(CURRENT)) {
                result.addFirst(path.getName());
            }
            path = path.getParentFile();
        }
        return result;
    }

    public static String getFilePath(File f) {
        String key;
        try {
            key = f.getCanonicalPath();
        }
        catch (Exception e) {
            key = f.getAbsolutePath();
        }
        return key;
    }
}

