/*
 * Decompiled with CFR 0.152.
 */
package org.multijava.universes.rt.policy;

import org.multijava.universes.rt.UrtPolicy;
import org.multijava.universes.rt.policy.UrtDefaultPolicy;

public class UrtRelaxed
extends UrtDefaultPolicy
implements UrtPolicy {
    @Override
    public void illegalCast() {
        try {
            throw new ClassCastException();
        }
        catch (ClassCastException e) {
            System.err.println("Universe Warning: there has been an illegal cast from readonly!");
            this.printException(e);
            return;
        }
    }

    @Override
    public void illegalArrayStore() {
        try {
            throw new ArrayStoreException();
        }
        catch (ArrayStoreException e) {
            System.err.println("Universe Warning: there has been an illegal write access to an array element!");
            this.printException(e);
            return;
        }
    }

    private void printException(Exception e) {
        StackTraceElement[] s = e.getStackTrace();
        for (int i = 1; i < s.length; ++i) {
            System.err.println("    at " + s[i]);
        }
    }
}

