/*
 * Decompiled with CFR 0.152.
 */
package org.multijava.universes.rt.impl;

import java.lang.ref.ReferenceQueue;
import org.multijava.universes.rt.UniverseRuntime;
import org.multijava.universes.rt.UrtImplementation;
import org.multijava.universes.rt.impl.UrtHashtable;
import org.multijava.universes.rt.impl.UrtHashtableArrayEntry;
import org.multijava.universes.rt.impl.UrtHashtableEntry;
import org.multijava.universes.rt.impl.UrtHashtableThreadEntry;
import org.multijava.universes.rt.impl.UrtWeakReference;
import org.multijava.util.Utils;

public class UrtDefaultImplementation
extends Utils
implements UrtImplementation {
    private UrtHashtable table = new UrtHashtable();
    private ReferenceQueue queue = new ReferenceQueue();

    public UrtDefaultImplementation() {
        UrtHashtableEntry e = this.table.put(this.table, new UrtHashtableEntry());
        e.obj = new UrtWeakReference(this.table);
        e.owner = e;
        this.setOwnerRep(Thread.currentThread(), this.table);
        this.setOwnerRep(this.queue, this.table);
    }

    @Override
    public void setOwnerRep(Object obj, Object owner) {
        UrtDefaultImplementation.assertTrue(obj != null);
        UrtDefaultImplementation.assertTrue(owner != null);
        if (obj instanceof Thread) {
            UrtHashtableEntry e = this.setOwner(obj, owner, new UrtHashtableThreadEntry(obj, this.queue));
        } else {
            UrtHashtableEntry e = this.setOwner(obj, owner, new UrtHashtableEntry());
        }
    }

    @Override
    public void setOwnerPeer(Object obj, Object current) {
        UrtDefaultImplementation.assertTrue(obj != null);
        UrtDefaultImplementation.assertTrue(current != null);
        UrtHashtableEntry e = this.table.get(current);
        UrtDefaultImplementation.assertTrue(e != null);
        UrtDefaultImplementation.assertTrue(e.owner != null, "No owner exists");
        this.setOwnerRep(obj, e.owner.obj.get());
    }

    @Override
    public void setConstructorData(Object currentObject, Object objectClass, int modifier) {
        UrtDefaultImplementation.assertTrue(currentObject != null);
        UrtDefaultImplementation.assertTrue(objectClass != null);
        UrtHashtableThreadEntry e = this.getCurrentThreadEntry();
        e.currentObject = currentObject;
        e.objectClass = objectClass;
        e.modifier = modifier;
    }

    @Override
    public void setOwner(Object o) {
        UrtDefaultImplementation.assertTrue(o != null);
        UrtHashtableThreadEntry e = this.getCurrentThreadEntry();
        UrtDefaultImplementation.assertTrue(e.currentObject != null);
        UrtDefaultImplementation.assertTrue(e.objectClass != null);
        if (e.objectClass != o.getClass()) {
            Object owner = UniverseRuntime.policy.getNativeOwner(o);
            if (owner == null) {
                this.setOwnerPeer(o, e.currentObject);
            } else {
                this.setOwnerRep(o, owner);
            }
            return;
        }
        switch (e.modifier) {
            case 40: {
                this.setOwnerPeer(o, e.currentObject);
                break;
            }
            case 42: {
                this.setOwnerRep(o, e.currentObject);
                break;
            }
            default: {
                UrtDefaultImplementation.assertTrue(e.modifier != e.modifier);
            }
        }
    }

    @Override
    public void setArrayOwnerRep(Object obj, Object owner, int arrayElementType) {
        UrtDefaultImplementation.assertTrue(obj != null);
        UrtDefaultImplementation.assertTrue(owner != null);
        UrtHashtableArrayEntry e = (UrtHashtableArrayEntry)this.setOwner(obj, owner, new UrtHashtableArrayEntry(arrayElementType));
    }

    @Override
    public void setArrayOwnerPeer(Object obj, Object current, int arrayElementType) {
        UrtDefaultImplementation.assertTrue(obj != null);
        UrtDefaultImplementation.assertTrue(current != null);
        UrtHashtableEntry e = this.table.get(current);
        UrtDefaultImplementation.assertTrue(e != null);
        this.setArrayOwnerRep(obj, e.owner.obj.get(), arrayElementType);
    }

    @Override
    public boolean checkArrayType(Object o, int elementType) {
        if (o == null) {
            return false;
        }
        UrtHashtableArrayEntry e = (UrtHashtableArrayEntry)this.table.get(o);
        if (e == null) {
            if (elementType == 40) {
                return UniverseRuntime.policy.isExternalPeer();
            }
            return elementType != 42;
        }
        return e.elementType == elementType;
    }

    @Override
    public boolean isPeer(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        UrtHashtableEntry e1 = this.getOwnerEntry(o1);
        UrtHashtableEntry e2 = this.getOwnerEntry(o2);
        if (e1 == null || e2 == null) {
            return UniverseRuntime.policy.isExternalPeer();
        }
        return e1 == e2;
    }

    @Override
    public boolean isOwner(Object owner, Object obj) {
        if (owner == null || obj == null) {
            return false;
        }
        UrtHashtableEntry r1 = this.table.get(owner);
        UrtHashtableEntry r2 = this.getOwnerEntry(obj);
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1 == r2;
    }

    @Override
    public Object getOwner(Object obj) {
        UrtDefaultImplementation.assertTrue(obj != null);
        UrtHashtableEntry ownerEntry = this.getOwnerEntry(obj);
        if (ownerEntry == null) {
            return null;
        }
        if (ownerEntry.obj == null) {
            return UniverseRuntime.policy.getCollectedOwner(obj);
        }
        return ownerEntry.obj.get();
    }

    @Override
    public Object getRootSetMember() {
        return this.queue;
    }

    @Override
    public void setContext(Object currentObject) {
        UrtDefaultImplementation.assertTrue(currentObject != null);
        UrtHashtableThreadEntry e = this.getCurrentThreadEntry();
        e.push(currentObject);
    }

    @Override
    public void resetContext() {
        UrtHashtableThreadEntry e = this.getCurrentThreadEntry();
        e.pop();
    }

    @Override
    public Object getContext() {
        UrtHashtableThreadEntry e = this.getCurrentThreadEntry();
        return e.getCurrentContext();
    }

    private UrtHashtableEntry setOwner(Object obj, Object owner, UrtHashtableEntry e) {
        UrtWeakReference o;
        e = this.table.put(obj, e);
        if (e.owner != null) {
            return e;
        }
        e.obj = new UrtWeakReference(obj, this.queue);
        e.owner = this.table.get(owner);
        UrtDefaultImplementation.assertTrue(e.owner != null);
        ++e.owner.children;
        UrtHashtableThreadEntry thread = this.getCurrentThreadEntry();
        thread.currentObject = owner;
        thread.objectClass = Object.class;
        thread.modifier = 40;
        block0: while ((o = (UrtWeakReference)this.queue.poll()) != null) {
            UrtHashtableEntry i = this.table.get(o);
            i.obj = null;
            while (i.children == 0 && i.obj == null) {
                this.table.remove(i);
                --i.owner.children;
                i = i.owner;
                if (i != null) continue;
                continue block0;
            }
        }
        return e;
    }

    private UrtHashtableEntry getOwnerEntry(Object obj) {
        UrtHashtableEntry e = this.table.get(obj);
        if (e == null) {
            return null;
        }
        UrtDefaultImplementation.assertTrue(e.owner != null);
        return e.owner;
    }

    private UrtHashtableThreadEntry getCurrentThreadEntry() {
        UrtHashtableThreadEntry thread = (UrtHashtableThreadEntry)this.table.get(Thread.currentThread());
        if (thread == null) {
            this.setOwnerRep(Thread.currentThread(), this.table);
            thread = (UrtHashtableThreadEntry)this.table.get(Thread.currentThread());
        }
        return thread;
    }
}

