#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <time.h>

#define OPTNUM 3141592

void set(int sock,int val){
  if(setsockopt(sock, IPPROTO_IP, OPTNUM, &val,sizeof(int())) == -1){
    perror("setsockopt");
  }
}

void setto(int sock,int val){
  int i;
  printf("Setting value to %d...\n",val);
  if(val >= 0 && val < get(sock)){
    while(get(sock) > val){
      set(sock,-1);
    }
  }else{
    if(val > 0){
      for(i = get(sock); i < val; i++){
	set(sock,1);
      }
    }
  }
}

int get(int sock){
  int size = sizeof(int);
  int val;
  if(getsockopt(sock, IPPROTO_IP, OPTNUM, &val,&size) == -1){
    perror("getsockopt");
  }else{
    return val;
  }
  return -1;
}

int main(int argc, char** argv){
  int sock,val;

  // create socket
  if((sock = socket(AF_INET,SOCK_RAW,IPPROTO_RAW)) == -1){
    perror("socket");
    exit(1);
  }
  
  val = get(sock);
  printf("Current value: %i\n",val);

  if(argc == 2){
    val = atoi(argv[1]);
    setto(sock,val);
  }else{
    val = val == 0 ? 1 : -1;
    set(sock,val);
  }
  printf("New value: %i\n",get(sock));

  return 0;
}
